// pump_mfc.cpp

#include <afxwin.h>
#include "resource.h"
#include <toolhelp.h>
#include "pump_mfc.h"



CTheApp theApp;



CMainWindow::CMainWindow()
	 {
	 m_ti.dwSize = sizeof (TIMERINFO);
	 m_lpti 	 = &m_ti;

	 Create (NULL, "MFC Message Pump demo",
             WS_OVERLAPPEDWINDOW, rectDefault, NULL, "MainMenu" );
     }


void CMainWindow::OnStartPostMessage()
	 {
	 //  Calibrate message pump
	 //
	 SetWindowText ("Calibrating Message Pump...");
	 m_lMsgCount   = 0;
	 ::TimerCount (m_lpti);
	 m_dwStartTime = m_ti.dwmsSinceStart;

	 if (m_lMsgCount < 10000)
		{
		m_lMsgCount++;
		}

	 ::TimerCount (m_lpti);
	 m_dwStopTime = m_ti.dwmsSinceStart;
	 m_dwCalibrationTime = m_dwStopTime - m_dwStartTime;

	 //  Now Start message pump
	 //
	 SetWindowText ("Posting 10,000 messages thru pump...");
	 m_lMsgCount   = 0;
	 ::TimerCount (m_lpti);
	 m_dwStartTime = m_ti.dwmsSinceStart;
	 PostMessage (WM_USER, 0, 0);
     }


void CMainWindow::OnStartSendMessage()
	 {
	 //  Calibrate message pump
	 //
	 SetWindowText ("Calibrating Message Pump...");
	 m_lMsgCount   = 0;
	 ::TimerCount (m_lpti);
	 m_dwStartTime = m_ti.dwmsSinceStart;

	 if (m_lMsgCount < 10000)
		{
		m_lMsgCount++;
		}

	 ::TimerCount (m_lpti);
	 m_dwStopTime = m_ti.dwmsSinceStart;
	 m_dwCalibrationTime = m_dwStopTime - m_dwStartTime;

	 //  Now Start message pump
	 //
	 SetWindowText ("Sending 10,000 messages thru pump...");
	 m_lMsgCount   = 0;
	 ::TimerCount (m_lpti);
	 m_dwStartTime = m_ti.dwmsSinceStart;


	 while (m_lMsgCount < 10000)
		{
		SendMessage (WM_USER + 1, 0, 0);
		}

     }


LONG CMainWindow::OnUserSendMessage (UINT wParam, LONG lParam)
	 {
	 char string [40];

	 m_lMsgCount++;

	 if (m_lMsgCount >= 10000)
		{
		//	Stop message pump & display msg rate
		//
		::TimerCount (m_lpti);
		m_dwStopTime = m_ti.dwmsSinceStart;

		DWORD dwElapsedTime = (m_dwStopTime - m_dwStartTime) - m_dwCalibrationTime;
		wsprintf (string, "MFC: Sent Msgs per second = %ld", (LONG) (1000. * ((double)m_lMsgCount/dwElapsedTime)));
		SetWindowText (string);
		}

	 return 0;
	 }


LONG CMainWindow::OnUserPostMessage (UINT wParam, LONG lParam)
	 {
	 char string [40];

	 m_lMsgCount++;

	 if (m_lMsgCount < 10000)
		{
		//	Keep message pump going
		//
		PostMessage (WM_USER, 0, 0L);
		}

	 else
		{
		//	Stop message pump & display msg rate
		//
		::TimerCount (m_lpti);
		m_dwStopTime = m_ti.dwmsSinceStart;

		DWORD dwElapsedTime = (m_dwStopTime - m_dwStartTime) - m_dwCalibrationTime;
		wsprintf (string, "MFC: Posted Msgs per second = %ld", (LONG) (1000. * ((double)m_lMsgCount/dwElapsedTime)));
		SetWindowText (string);
		}

	 return 0;
	 }



BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
	ON_MESSAGE	(WM_USER,	  OnUserPostMessage)
	ON_MESSAGE	(WM_USER + 1, OnUserSendMessage)
	ON_COMMAND	(IDM_STARTPOSTMESSAGE, OnStartPostMessage )
	ON_COMMAND	(IDM_STARTSENDMESSAGE, OnStartSendMessage )
END_MESSAGE_MAP()



BOOL CTheApp::InitInstance()
     {
     TRACE( "HELLO WORLD\n" );

	 m_pMainWnd = new CMainWindow();
     m_pMainWnd->ShowWindow( m_nCmdShow );
     m_pMainWnd->UpdateWindow();

     return TRUE;
	 }
